<?php $__env->startSection('title', 'Role Capabilities - Apa yang Bisa Diakses'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h2>Role Capabilities - Apa yang Bisa Diakses</h2>
    <div class="actions">
        <a href="<?php echo e(route('admin.permissions.index')); ?>" class="btn btn-secondary">📋 All Permissions</a>
        <a href="<?php echo e(route('admin.permissions.matrix')); ?>" class="btn btn-secondary">📊 Matrix View</a>
    </div>
</div>

<div class="card" style="margin-bottom:16px;padding:12px;background:#f0f9ff;border-left:4px solid #0ea5e9">
    <p style="margin:0;font-size:13px;color:#0c4a6e">
        🎯 <strong>Role Capabilities:</strong> Halaman ini menampilkan fungsi apa saja yang bisa diakses oleh setiap role dalam sistem.
    </p>
</div>

<?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php
        $permissionsByCategory = $role->permissions->groupBy('category');
    ?>
    
    <div class="card" style="margin-bottom:24px">
        <div class="role-header" style="display:flex;justify-content:space-between;align-items:center;margin-bottom:20px;padding-bottom:16px;border-bottom:2px solid #f3f4f6">
            <div>
                <h3 style="margin:0;display:flex;align-items:center;gap:12px">
                    <?php switch($role->name):
                        case ('admin'): ?>
                            <span style="background:#dc2626;color:white;padding:8px 12px;border-radius:8px;font-size:14px">
                                👑 <?php echo e($role->display_name ?? 'Administrator'); ?>

                            </span>
                            <?php break; ?>
                        <?php case ('manager'): ?>
                            <span style="background:#059669;color:white;padding:8px 12px;border-radius:8px;font-size:14px">
                                👔 <?php echo e($role->display_name ?? 'Manager'); ?>

                            </span>
                            <?php break; ?>
                        <?php case ('supervisor'): ?>
                            <span style="background:#ea580c;color:white;padding:8px 12px;border-radius:8px;font-size:14px">
                                👨‍💼 <?php echo e($role->display_name ?? 'Supervisor'); ?>

                            </span>
                            <?php break; ?>
                        <?php case ('employee'): ?>
                            <span style="background:#6366f1;color:white;padding:8px 12px;border-radius:8px;font-size:14px">
                                👤 <?php echo e($role->display_name ?? 'Employee'); ?>

                            </span>
                            <?php break; ?>
                        <?php default: ?>
                            <span style="background:#6b7280;color:white;padding:8px 12px;border-radius:8px;font-size:14px">
                                🏷️ <?php echo e($role->display_name ?? ucfirst($role->name)); ?>

                            </span>
                    <?php endswitch; ?>
                </h3>
                <?php if($role->description): ?>
                    <p style="margin:8px 0 0 0;color:#6b7280;font-size:14px"><?php echo e($role->description); ?></p>
                <?php endif; ?>
            </div>
            <div style="text-align:right">
                <div style="font-size:18px;font-weight:600;color:#0ea5e9"><?php echo e($role->permissions->count()); ?></div>
                <div style="font-size:12px;color:#6b7280">permissions</div>
                <div style="font-size:14px;font-weight:500;color:#374151;margin-top:4px"><?php echo e($role->users->count()); ?> users</div>
            </div>
        </div>

        <?php if($role->permissions->count() > 0): ?>
            <div class="capabilities-grid" style="display:grid;grid-template-columns:repeat(auto-fit, minmax(280px, 1fr));gap:16px">
                <?php $__currentLoopData = $permissionsByCategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category => $categoryPermissions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="capability-category" style="background:#f9fafb;border-radius:8px;padding:16px;border-left:4px solid #<?php echo e($role->name === 'admin' ? 'dc2626' : ($role->name === 'manager' ? '059669' : ($role->name === 'supervisor' ? 'ea580c' : '6366f1'))); ?>">
                        <h4 style="margin:0 0 12px 0;color:#1f2937;display:flex;align-items:center;gap:8px">
                            <?php switch($category):
                                case ('dashboard'): ?>
                                    📊 Dashboard
                                    <?php break; ?>
                                <?php case ('users'): ?> 
                                    👥 User Management
                                    <?php break; ?>
                                <?php case ('roles'): ?>
                                    🛡️ Role Management
                                    <?php break; ?>
                                <?php case ('attendance'): ?>
                                    ⏰ Attendance
                                    <?php break; ?>
                                <?php case ('shifts'): ?>
                                    🕐 Shifts
                                    <?php break; ?>
                                <?php case ('reports'): ?>
                                    📊 Reports
                                    <?php break; ?>
                                <?php case ('complaints'): ?>
                                    📝 Complaints/Leave
                                    <?php break; ?>
                                <?php case ('profile'): ?>
                                    👤 Profile
                                    <?php break; ?>
                                <?php case ('system'): ?>
                                    ⚙️ System
                                    <?php break; ?>
                                <?php default: ?>
                                    📋 <?php echo e(ucfirst($category)); ?>

                            <?php endswitch; ?>
                            <span style="background:#e5e7eb;color:#374151;padding:2px 6px;border-radius:4px;font-size:11px">
                                <?php echo e($categoryPermissions->count()); ?>

                            </span>
                        </h4>
                        
                        <ul style="margin:0;padding:0;list-style:none">
                            <?php $__currentLoopData = $categoryPermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li style="margin-bottom:6px;display:flex;align-items:flex-start;gap:6px">
                                    <span style="color:#059669;font-size:12px;margin-top:1px">✓</span>
                                    <div>
                                        <div style="font-size:13px;color:#374151;font-weight:500">
                                            <?php echo e($permission->display_name); ?>

                                        </div>
                                        <?php if($permission->description): ?>
                                            <div style="font-size:11px;color:#6b7280;margin-top:1px">
                                                <?php echo e(Str::limit($permission->description, 60)); ?>

                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            
            <div style="margin-top:16px;padding:12px;background:#f0f9ff;border-radius:6px;border-left:4px solid #<?php echo e($role->name === 'admin' ? 'dc2626' : ($role->name === 'manager' ? '059669' : ($role->name === 'supervisor' ? 'ea580c' : '6366f1'))); ?>">
                <strong style="color:#0c4a6e">Ringkasan Akses:</strong>
                <span style="color:#0c4a6e">
                    Role <?php echo e($role->display_name ?? ucfirst($role->name)); ?> memiliki akses ke <?php echo e($role->permissions->count()); ?> fungsi 
                    dalam <?php echo e($permissionsByCategory->count()); ?> kategori berbeda.
                </span>
                
                <?php if($role->name === 'admin'): ?>
                    <div style="margin-top:8px;color:#7c2d12;font-size:12px">
                        <strong>⚠️ Super Admin:</strong> Memiliki akses penuh ke seluruh sistem termasuk manajemen user, role, dan pengaturan sistem.
                    </div>
                <?php elseif($role->name === 'manager'): ?>
                    <div style="margin-top:8px;color:#14532d;font-size:12px">
                        <strong>👔 Manager:</strong> Dapat mengelola user dan melihat laporan, tetapi tidak dapat mengubah pengaturan sistem.
                    </div>
                <?php elseif($role->name === 'supervisor'): ?>
                    <div style="margin-top:8px;color:#9a3412;font-size:12px">
                        <strong>👨‍💼 Supervisor:</strong> Fokus pada pengelolaan absensi dan pengawasan tim dengan akses terbatas.
                    </div>
                <?php elseif($role->name === 'employee'): ?>
                    <div style="margin-top:8px;color:#3730a3;font-size:12px">
                        <strong>👤 Employee:</strong> Akses dasar untuk absensi, melihat shift, dan mengelola profil sendiri.
                    </div>
                <?php endif; ?>
            </div>
        <?php else: ?>
            <div style="text-align:center;padding:40px;color:#6b7280;background:#f9fafb;border-radius:8px">
                🔒 Role ini belum memiliki permissions yang diberikan
            </div>
        <?php endif; ?>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<style>
.capabilities-grid {
    margin-bottom: 16px;
}

.capability-category {
    min-height: 120px;
}

@media (max-width: 768px) {
    .capabilities-grid {
        grid-template-columns: 1fr;
    }
    
    .role-header {
        flex-direction: column;
        align-items: flex-start;
        gap: 12px;
    }
    
    .role-header > div:last-child {
        text-align: left;
    }
}
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/proa8625/public_html/absensi.prodental.my.id/resources/views/admin/permissions/capabilities.blade.php ENDPATH**/ ?>