<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="theme-color" content="#1ec7e6">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <title>Buat Keluhan - Sistem Absensi</title>
    <style>
        /* CSS tetap sama seperti yang Anda berikan */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            -webkit-tap-highlight-color: transparent;
        }
        
        html {
            -webkit-text-size-adjust: 100%;
            -ms-text-size-adjust: 100%;
        }

        body {
            font-family: Arial, sans-serif;
            background-color: #f5f5f5;
            width: 100%;
            max-width: 393px;
            min-height: 100vh;
            margin: 0 auto;
            overflow-y: auto;
        }
        
        @media (min-width: 394px) {
            body {
                box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
            }
        }

        .header {
            background: linear-gradient(135deg, #1ec7e6, #0ea5e9);
            color: white;
            padding: 20px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        }

        .header-left {
            display: flex;
            align-items: center;
        }

        .back-btn {
            background: rgba(255, 255, 255, 0.2);
            color: white;
            border: none;
            padding: 10px;
            border-radius: 50%;
            font-size: 18px;
            cursor: pointer;
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 16px;
            text-decoration: none;
        }

        .header-title {
            font-size: 18px;
            font-weight: 600;
        }

        .history-btn {
            background: rgba(255, 255, 255, 0.2);
            color: white;
            border: none;
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 13px;
            font-weight: 600;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
        }

        .content {
            padding: 20px;
        }

        .info-banner {
            background: linear-gradient(135deg, #f59e0b, #d97706);
            color: white;
            border-radius: 12px;
            padding: 16px;
            margin-bottom: 20px;
            display: flex;
            align-items: flex-start;
            gap: 12px;
        }

        .info-icon {
            font-size: 24px;
            flex-shrink: 0;
        }

        .info-text {
            flex: 1;
            font-size: 13px;
            line-height: 1.5;
        }

        .form-section {
            background: white;
            border-radius: 16px;
            padding: 24px;
            margin-bottom: 20px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-label {
            display: block;
            font-size: 14px;
            color: #374151;
            font-weight: 600;
            margin-bottom: 8px;
        }

        .required {
            color: #ef4444;
        }

        .form-input,
        .form-select,
        .form-textarea {
            width: 100%;
            padding: 12px 16px;
            border: 2px solid #e5e7eb;
            border-radius: 10px;
            font-size: 14px;
            transition: all 0.2s ease;
            font-family: Arial, sans-serif;
        }

        .form-input:focus,
        .form-select:focus,
        .form-textarea:focus {
            outline: none;
            border-color: #1ec7e6;
            background: #f0f9ff;
        }

        .form-select {
            cursor: pointer;
            appearance: none;
            background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' viewBox='0 0 12 12'%3E%3Cpath fill='%236b7280' d='M6 9L1 4h10z'/%3E%3C/svg%3E");
            background-repeat: no-repeat;
            background-position: right 12px center;
        }

        .form-textarea {
            min-height: 120px;
            resize: vertical;
        }

        .form-hint {
            font-size: 12px;
            color: #6b7280;
            margin-top: 6px;
        }

        .priority-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 10px;
        }

        .priority-card {
            border: 2px solid #e5e7eb;
            border-radius: 10px;
            padding: 16px 12px;
            text-align: center;
            cursor: pointer;
            transition: all 0.2s ease;
            position: relative;
        }

        .priority-card input {
            display: none;
        }

        .priority-card.selected {
            border-width: 3px;
        }

        .priority-card.low.selected {
            border-color: #10b981;
            background: #ecfdf5;
        }

        .priority-card.medium.selected {
            border-color: #f59e0b;
            background: #fffbeb;
        }

        .priority-card.high.selected {
            border-color: #ef4444;
            background: #fef2f2;
        }

        .priority-icon {
            font-size: 28px;
            margin-bottom: 8px;
        }

        .priority-label {
            font-size: 13px;
            font-weight: 600;
            color: #374151;
        }

        .file-upload {
            border: 2px dashed #d1d5db;
            border-radius: 10px;
            padding: 24px;
            text-align: center;
            cursor: pointer;
            transition: all 0.2s ease;
        }

        .file-upload:hover {
            border-color: #1ec7e6;
            background: #f0f9ff;
        }

        .file-upload.has-file {
            border-color: #10b981;
            background: #ecfdf5;
        }

        .upload-icon {
            font-size: 48px;
            margin-bottom: 12px;
        }

        .upload-text {
            font-size: 14px;
            color: #374151;
            font-weight: 600;
            margin-bottom: 4px;
        }

        .upload-hint {
            font-size: 12px;
            color: #6b7280;
        }

        .file-preview {
            display: none;
            margin-top: 16px;
            padding: 12px;
            background: white;
            border-radius: 8px;
            text-align: left;
        }

        .file-preview.show {
            display: block;
        }

        .file-info {
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .file-icon {
            font-size: 32px;
        }

        .file-details {
            flex: 1;
        }

        .file-name {
            font-size: 14px;
            font-weight: 600;
            color: #374151;
            margin-bottom: 4px;
        }

        .file-size {
            font-size: 12px;
            color: #6b7280;
        }

        .remove-file {
            background: #ef4444;
            color: white;
            border: none;
            padding: 6px 12px;
            border-radius: 6px;
            font-size: 12px;
            cursor: pointer;
        }

        .button-group {
            display: grid;
            grid-template-columns: 1fr 2fr;
            gap: 12px;
            margin-top: 24px;
        }

        .btn {
            padding: 14px 24px;
            border: none;
            border-radius: 12px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s ease;
        }

        .btn-cancel {
            background: #f3f4f6;
            color: #6b7280;
            text-decoration: none;
            display: inline-block;
            text-align: center;
            line-height: normal;
        }

        .btn-submit {
            background: #1ec7e6;
            color: white;
            border: none;
        }

        .btn-submit:hover {
            background: #0ea5e9;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(30, 199, 230, 0.3);
        }

        .error-message {
            color: #ef4444;
            font-size: 12px;
            margin-top: 5px;
            display: none;
        }

        .error-message.show {
            display: block;
        }

        .form-input.error,
        .form-select.error,
        .form-textarea.error {
            border-color: #ef4444;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="header-left">
            <a href="<?php echo e(route('dashboard')); ?>" class="back-btn">←</a>
            <div class="header-title">Buat Keluhan</div>
        </div>
        <a href="<?php echo e(route('complaints.history')); ?>" class="history-btn">Riwayat</a>
    </div>

    <div class="content">
        <div class="info-banner">
            <div class="info-icon">⚠️</div>
            <div class="info-text">
                Sampaikan keluhan Anda terkait masalah teknis atau sistem. Tim teknisi kami akan segera menindaklanjuti.
            </div>
        </div>

        <form action="<?php echo e(route('complaints.store')); ?>" method="POST" enctype="multipart/form-data" class="form-section" id="complaintForm">
            <?php echo csrf_field(); ?>
            
            <?php if($errors->any()): ?>
                <div style="background: #fee2e2; color: #dc2626; padding: 12px; border-radius: 8px; margin-bottom: 20px; font-size: 14px;">
                    <strong>Terjadi kesalahan:</strong>
                    <ul style="margin-top: 5px; padding-left: 20px;">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <div class="form-group">
                <label class="form-label">
                    Kategori Masalah <span class="required">*</span>
                </label>
                <select class="form-select <?php $__errorArgs = ['category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="category" id="category" required>
                    <option value="">Pilih Kategori</option>
                    <option value="hardware" <?php echo e(old('category') == 'hardware' ? 'selected' : ''); ?>>Hardware/Perangkat</option>
                    <option value="software" <?php echo e(old('category') == 'software' ? 'selected' : ''); ?>>Software/Aplikasi</option>
                    <option value="network" <?php echo e(old('category') == 'network' ? 'selected' : ''); ?>>Jaringan/Internet</option>
                    <option value="system" <?php echo e(old('category') == 'system' ? 'selected' : ''); ?>>Sistem Absensi</option>
                    <option value="access" <?php echo e(old('category') == 'access' ? 'selected' : ''); ?>>Akses/Login</option>
                    <option value="other" <?php echo e(old('category') == 'other' ? 'selected' : ''); ?>>Lainnya</option>
                </select>
                <?php $__errorArgs = ['category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="error-message show"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="form-group">
                <label class="form-label">
                    Judul Keluhan <span class="required">*</span>
                </label>
                <input 
                    type="text" 
                    class="form-input <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                    name="title"
                    id="title"
                    value="<?php echo e(old('title')); ?>"
                    placeholder="Ringkasan masalah yang dialami"
                    maxlength="100"
                    required
                >
                <div class="form-hint">Maksimal 100 karakter</div>
                <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="error-message show"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="form-group">
                <label class="form-label">
                    Deskripsi Masalah <span class="required">*</span>
                </label>
                <textarea 
                    class="form-textarea <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                    name="description"
                    id="description"
                    placeholder="Jelaskan masalah secara detail: kapan terjadi, apa yang terjadi, dan apa yang sudah dicoba..."
                    required
                ><?php echo e(old('description')); ?></textarea>
                <div class="form-hint">Semakin detail, semakin cepat teknisi dapat membantu</div>
                <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="error-message show"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="form-group">
                <label class="form-label">
                    Lokasi/Ruangan
                </label>
                <input 
                    type="text" 
                    class="form-input <?php $__errorArgs = ['location'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                    name="location"
                    id="location"
                    value="<?php echo e(old('location')); ?>"
                    placeholder="Contoh: Lantai 2, Ruang IT"
                >
                <?php $__errorArgs = ['location'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="error-message show"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="form-group">
                <label class="form-label">
                    Tingkat Urgensi <span class="required">*</span>
                </label>
                <div class="priority-grid">
                    <label class="priority-card low <?php if(old('priority') == 'low'): ?> selected <?php endif; ?>">
                        <input type="radio" name="priority" value="low" 
                               <?php echo e(old('priority') == 'low' ? 'checked' : ''); ?> required>
                        <div class="priority-icon">🟢</div>
                        <div class="priority-label">Rendah</div>
                    </label>
                    <label class="priority-card medium <?php if(old('priority') == 'medium'): ?> selected <?php endif; ?>">
                        <input type="radio" name="priority" value="medium"
                               <?php echo e(old('priority') == 'medium' ? 'checked' : ''); ?>>
                        <div class="priority-icon">🟡</div>
                        <div class="priority-label">Sedang</div>
                    </label>
                    <label class="priority-card high <?php if(old('priority') == 'high'): ?> selected <?php endif; ?>">
                        <input type="radio" name="priority" value="high"
                               <?php echo e(old('priority') == 'high' ? 'checked' : ''); ?>>
                        <div class="priority-icon">🔴</div>
                        <div class="priority-label">Tinggi</div>
                    </label>
                </div>
                <?php $__errorArgs = ['priority'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="error-message show"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="form-group">
                <label class="form-label">
                    Lampiran Foto (Opsional)
                </label>
                <div class="file-upload" id="fileUpload" onclick="document.getElementById('attachment').click()">
                    <input 
                        type="file" 
                        name="attachment"
                        id="attachment" 
                        accept="image/*"
                        style="display: none;"
                        onchange="handleFileSelect(event)"
                    >
                    <div class="upload-icon">📷</div>
                    <div class="upload-text">Upload Foto Masalah</div>
                    <div class="upload-hint">PNG, JPG (Max 5MB)</div>
                    
                    <div class="file-preview" id="filePreview">
                        <div class="file-info">
                            <div class="file-icon">🖼️</div>
                            <div class="file-details">
                                <div class="file-name" id="fileName"></div>
                                <div class="file-size" id="fileSize"></div>
                            </div>
                            <button type="button" class="remove-file" onclick="removeFile(event)">✕</button>
                        </div>
                    </div>
                </div>
                <?php $__errorArgs = ['attachment'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="error-message show"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="button-group">
                <a href="<?php echo e(route('complaints.history')); ?>" class="btn btn-cancel">Batal</a>
                <button type="submit" class="btn btn-submit" id="submitBtn">Kirim Keluhan</button>
            </div>
        </form>
    </div>

    <script>
        // Priority card selection
        document.querySelectorAll('.priority-card').forEach(card => {
            card.addEventListener('click', function() {
                document.querySelectorAll('.priority-card').forEach(c => c.classList.remove('selected'));
                this.classList.add('selected');
                this.querySelector('input').checked = true;
            });
        });

        // File upload
        function handleFileSelect(event) {
            const file = event.target.files[0];
            if (file) {
                if (file.size > 5 * 1024 * 1024) {
                    alert('Ukuran file terlalu besar. Maksimal 5MB');
                    event.target.value = '';
                    return;
                }

                document.getElementById('fileName').textContent = file.name;
                document.getElementById('fileSize').textContent = formatFileSize(file.size);
                document.getElementById('filePreview').classList.add('show');
                document.getElementById('fileUpload').classList.add('has-file');
            }
        }

        function removeFile(event) {
            event.stopPropagation();
            document.getElementById('attachment').value = '';
            document.getElementById('filePreview').classList.remove('show');
            document.getElementById('fileUpload').classList.remove('has-file');
        }

        function formatFileSize(bytes) {
            if (bytes === 0) return '0 Bytes';
            const k = 1024;
            const sizes = ['Bytes', 'KB', 'MB'];
            const i = Math.floor(Math.log(bytes) / Math.log(k));
            return Math.round(bytes / Math.pow(k, i) * 100) / 100 + ' ' + sizes[i];
        }

        // Form validation
        document.getElementById('complaintForm').addEventListener('submit', function(e) {
            const submitBtn = document.getElementById('submitBtn');
            submitBtn.disabled = true;
            submitBtn.innerHTML = 'Mengirim...';
            
            // Simple validation
            let isValid = true;
            
            // Check category
            const category = document.getElementById('category');
            if (!category.value) {
                category.classList.add('error');
                showError(category, 'Kategori wajib dipilih');
                isValid = false;
            } else {
                category.classList.remove('error');
                hideError(category);
            }
            
            // Check title
            const title = document.getElementById('title');
            if (!title.value.trim()) {
                title.classList.add('error');
                showError(title, 'Judul wajib diisi');
                isValid = false;
            } else {
                title.classList.remove('error');
                hideError(title);
            }
            
            // Check description
            const description = document.getElementById('description');
            if (!description.value.trim()) {
                description.classList.add('error');
                showError(description, 'Deskripsi wajib diisi');
                isValid = false;
            } else {
                description.classList.remove('error');
                hideError(description);
            }
            
            // Check priority
            const priority = document.querySelector('input[name="priority"]:checked');
            if (!priority) {
                showGeneralError('Tingkat urgensi wajib dipilih');
                isValid = false;
            }
            
            if (!isValid) {
                e.preventDefault();
                submitBtn.disabled = false;
                submitBtn.innerHTML = 'Kirim Keluhan';
            }
        });

        function showError(element, message) {
            let errorDiv = element.nextElementSibling;
            while (errorDiv && !errorDiv.classList.contains('error-message')) {
                errorDiv = errorDiv.nextElementSibling;
            }
            
            if (errorDiv && errorDiv.classList.contains('error-message')) {
                errorDiv.textContent = message;
                errorDiv.classList.add('show');
            }
        }

        function hideError(element) {
            let errorDiv = element.nextElementSibling;
            while (errorDiv && !errorDiv.classList.contains('error-message')) {
                errorDiv = errorDiv.nextElementSibling;
            }
            
            if (errorDiv && errorDiv.classList.contains('error-message')) {
                errorDiv.classList.remove('show');
            }
        }

        function showGeneralError(message) {
            alert(message);
        }
    </script>
</body>
</html><?php /**PATH /home/proa8625/public_html/absensi.prodental.my.id/resources/views/complaints/complaint-form.blade.php ENDPATH**/ ?>