<?php $__env->startSection('title', 'Kelola Role'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h2>Kelola Role</h2>
    <div class="actions">
        <a href="<?php echo e(route('admin.roles.create')); ?>" class="btn btn-primary">+ Tambah Role</a>
    </div>
</div>

<div class="card" style="margin-bottom:8px;padding:12px;background:#f0f9ff;border-left:4px solid #0ea5e9">
    <p style="margin:0;font-size:13px;color:#0c4a6e">
        💡 <strong>Info Role:</strong> Role menentukan hak akses pengguna dalam sistem. Role sistem (admin, manager, employee, supervisor) tidak dapat dihapus.
    </p>
</div>

<?php if(session('success')): ?>
    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
<?php endif; ?>

<?php if($errors->any()): ?>
    <div class="alert alert-error">
        <ul style="margin:0;padding-left:20px">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php endif; ?>

<div style="overflow-x:auto">
<table>
    <thead>
        <tr>
            <th>Nama Role</th>
            <th>Nama Tampilan</th>
            <th>Deskripsi</th>
            <th style="text-align:center">Jumlah User</th>
            <th style="text-align:center">Tipe</th>
            <th>Aksi</th>
        </tr>
    </thead>
    <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <tr>
            <td>
                <span style="font-weight:600;color:#0ea5e9;font-family:monospace"><?php echo e($role->name); ?></span>
            </td>
            <td><strong><?php echo e($role->display_name); ?></strong></td>
            <td><?php echo e($role->description ?: '-'); ?></td>
            <td style="text-align:center">
                <a href="<?php echo e(route('admin.roles.show', $role)); ?>" class="link-badge">
                    <?php echo e($role->users_count); ?> user
                </a>
            </td>
            <td style="text-align:center">
                <?php
                    $systemRoles = ['admin', 'manager', 'employee', 'supervisor'];
                    $isSystem = in_array($role->name, $systemRoles);
                ?>
                <?php if($isSystem): ?>
                    <span style="background:#f3f4f6;color:#374151;padding:2px 8px;border-radius:12px;font-size:11px;font-weight:500">
                        🔒 Sistem
                    </span>
                <?php else: ?>
                    <span style="background:#dcfce7;color:#166534;padding:2px 8px;border-radius:12px;font-size:11px;font-weight:500">
                        ✨ Custom
                    </span>
                <?php endif; ?>
            </td>
            <td>
                <div class="action-buttons">
                    <a href="<?php echo e(route('admin.roles.show', $role)); ?>" class="btn btn-sm btn-secondary" title="Detail">👁️</a>
                    <a href="<?php echo e(route('admin.roles.edit', $role)); ?>" class="btn btn-sm btn-warning" title="Edit">✏️</a>
                    <?php if(!$isSystem): ?>
                        <form method="POST" action="<?php echo e(route('admin.roles.destroy', $role)); ?>" style="display:inline" 
                              onsubmit="return confirm('Yakin ingin menghapus role <?php echo e($role->display_name); ?>?')">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-sm btn-danger" title="Hapus">🗑️</button>
                        </form>
                    <?php endif; ?>
                </div>
            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <tr>
            <td colspan="6" style="text-align:center;padding:40px;color:#6b7280">
                📝 Belum ada role yang dibuat
            </td>
        </tr>
        <?php endif; ?>
    </tbody>
</table>
</div>

<style>
.link-badge {
    display: inline-block;
    padding: 4px 8px;
    background: #e0e7ff;
    color: #3730a3;
    border-radius: 6px;
    text-decoration: none;
    font-size: 12px;
    font-weight: 500;
}

.link-badge:hover {
    background: #c7d2fe;
    color: #312e81;
}

.action-buttons {
    display: flex;
    gap: 4px;
    align-items: center;
}

.btn-sm {
    padding: 4px 8px;
    font-size: 12px;
    min-width: 32px;
    text-align: center;
}
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/proa8625/public_html/absensi.prodental.my.id/resources/views/admin/roles/index.blade.php ENDPATH**/ ?>