<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="theme-color" content="#1ec7e6">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <title>Riwayat Keluhan - Sistem Absensi</title>
    <style>
        /* Your existing CSS remains the same */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            -webkit-tap-highlight-color: transparent;
        }
        
        html {
            -webkit-text-size-adjust: 100%;
            -ms-text-size-adjust: 100%;
        }

        body {
            font-family: Arial, sans-serif;
            background-color: #f5f5f5;
            width: 100%;
            max-width: 393px;
            min-height: 100vh;
            margin: 0 auto;
            overflow-y: auto;
            padding-bottom: 80px;
        }
        
        @media (min-width: 394px) {
            body {
                box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
            }
        }

        .header {
            background: linear-gradient(135deg, #1ec7e6, #0ea5e9);
            color: white;
            padding: 20px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        }

        .header-left {
            display: flex;
            align-items: center;
        }

        .back-btn {
            background: rgba(255, 255, 255, 0.2);
            color: white;
            border: none;
            padding: 10px;
            border-radius: 50%;
            font-size: 18px;
            cursor: pointer;
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 16px;
            text-decoration: none;
        }

        .header-title {
            font-size: 18px;
            font-weight: 600;
        }

        .add-btn {
            background: rgba(255, 255, 255, 0.2);
            color: white;
            border: none;
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
        }

        .content {
            padding: 20px;
        }

        .stats-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 12px;
            margin-bottom: 20px;
        }

        .stat-card {
            background: white;
            border-radius: 12px;
            padding: 16px;
            text-align: center;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
        }

        .stat-number {
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 4px;
        }

        .stat-number.pending { color: #f59e0b; }
        .stat-number.process { color: #3b82f6; }
        .stat-number.done { color: #10b981; }

        .stat-label {
            font-size: 12px;
            color: #6b7280;
        }

        .filter-tabs {
            display: flex;
            gap: 8px;
            margin-bottom: 20px;
            overflow-x: auto;
            padding-bottom: 5px;
        }

        .filter-tab {
            background: white;
            border: 2px solid #e5e7eb;
            color: #6b7280;
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 13px;
            font-weight: 600;
            cursor: pointer;
            white-space: nowrap;
            transition: all 0.2s ease;
            text-decoration: none;
            display: inline-block;
        }

        .filter-tab.active {
            background: #1ec7e6;
            border-color: #1ec7e6;
            color: white;
        }

        .complaint-list {
            display: flex;
            flex-direction: column;
            gap: 12px;
        }

        .complaint-card {
            background: white;
            border-radius: 12px;
            padding: 16px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
            cursor: pointer;
            transition: all 0.2s ease;
            text-decoration: none;
            color: inherit;
            display: block;
        }

        .complaint-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        .complaint-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 12px;
        }

        .ticket-number {
            font-size: 12px;
            color: #6b7280;
            font-family: monospace;
        }

        .status-badge {
            padding: 4px 10px;
            border-radius: 12px;
            font-size: 11px;
            font-weight: 600;
        }

        .status-badge.pending {
            background: #fef3c7;
            color: #d97706;
        }

        .status-badge.process {
            background: #dbeafe;
            color: #2563eb;
        }

        .status-badge.done {
            background: #d1fae5;
            color: #059669;
        }

        .complaint-title {
            font-size: 15px;
            font-weight: 600;
            color: #374151;
            margin-bottom: 8px;
        }

        .complaint-meta {
            display: flex;
            align-items: center;
            gap: 12px;
            flex-wrap: wrap;
            margin-bottom: 8px;
        }

        .meta-item {
            display: flex;
            align-items: center;
            gap: 4px;
            font-size: 12px;
            color: #6b7280;
        }

        .priority-dot {
            width: 8px;
            height: 8px;
            border-radius: 50%;
        }

        .priority-dot.low { background: #10b981; }
        .priority-dot.medium { background: #f59e0b; }
        .priority-dot.high { background: #ef4444; }

        .complaint-description {
            font-size: 13px;
            color: #6b7280;
            line-height: 1.5;
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }

        .empty-state {
            text-align: center;
            padding: 60px 20px;
        }

        .empty-icon {
            font-size: 64px;
            margin-bottom: 16px;
            opacity: 0.3;
        }

        .empty-text {
            font-size: 16px;
            color: #6b7280;
            margin-bottom: 8px;
        }

        .empty-subtext {
            font-size: 14px;
            color: #9ca3af;
            margin-bottom: 24px;
        }

        .empty-btn {
            background: #1ec7e6;
            color: white;
            border: none;
            padding: 12px 24px;
            border-radius: 10px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
        }

        /* Pagination Styles */
        .pagination {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 10px;
            margin-top: 20px;
            padding: 10px 0;
        }

        .page-link {
            padding: 8px 12px;
            background: white;
            border: 1px solid #e5e7eb;
            border-radius: 6px;
            text-decoration: none;
            color: #374151;
            font-size: 14px;
        }

        .page-link.active {
            background: #1ec7e6;
            color: white;
            border-color: #1ec7e6;
        }

        .page-link:hover:not(.active) {
            background: #f3f4f6;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="header-left">
            <a href="<?php echo e(route('dashboard')); ?>" class="back-btn">←</a>
            <div class="header-title">Riwayat Keluhan</div>
        </div>
        <a href="<?php echo e(route('complaints.form')); ?>" class="add-btn">+ Buat</a>
    </div>

    <div class="content">
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-number pending"><?php echo e($stats['pending'] ?? 0); ?></div>
                <div class="stat-label">Pending</div>
            </div>
            <div class="stat-card">
                <div class="stat-number process"><?php echo e($stats['process'] ?? 0); ?></div>
                <div class="stat-label">Diproses</div>
            </div>
            <div class="stat-card">
                <div class="stat-number done"><?php echo e($stats['done'] ?? 0); ?></div>
                <div class="stat-label">Selesai</div>
            </div>
        </div>

        <div class="filter-tabs">
            <a href="<?php echo e(route('complaints.history')); ?>" 
               class="filter-tab <?php echo e($currentStatus == 'all' ? 'active' : ''); ?>">
                Semua
            </a>
            <a href="<?php echo e(route('complaints.history', ['status' => 'pending'])); ?>" 
               class="filter-tab <?php echo e($currentStatus == 'pending' ? 'active' : ''); ?>">
                Pending
            </a>
            <a href="<?php echo e(route('complaints.history', ['status' => 'process'])); ?>" 
               class="filter-tab <?php echo e($currentStatus == 'process' ? 'active' : ''); ?>">
                Diproses
            </a>
            <a href="<?php echo e(route('complaints.history', ['status' => 'done'])); ?>" 
               class="filter-tab <?php echo e($currentStatus == 'done' ? 'active' : ''); ?>">
                Selesai
            </a>
        </div>

        <div class="complaint-list">
            <?php $__empty_1 = true; $__currentLoopData = $complaints; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $complaint): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <a href="<?php echo e(route('complaints.show', $complaint['id'])); ?>" class="complaint-card">
                    <div class="complaint-header">
                        <div class="ticket-number"><?php echo e($complaint['ticketNumber']); ?></div>
                        <div class="status-badge <?php echo e($complaint['status']); ?>">
                            <?php
                                $statusText = [
                                    'pending' => 'Menunggu',
                                    'process' => 'Diproses',
                                    'done' => 'Selesai',
                                ];
                            ?>
                            <?php echo e($statusText[$complaint['status']] ?? $complaint['status']); ?>

                        </div>
                    </div>
                    <div class="complaint-title"><?php echo e($complaint['title']); ?></div>
                    <div class="complaint-meta">
                        <div class="meta-item">
                            <span>📁</span>
                            <?php
                                $categoryText = [
                                    'hardware' => 'Hardware/Perangkat',
                                    'software' => 'Software/Aplikasi',
                                    'network' => 'Jaringan/Internet',
                                    'system' => 'Sistem Absensi',
                                    'access' => 'Akses/Login',
                                    'general' => 'Umum',
                                    'other' => 'Lainnya',
                                ];
                            ?>
                            <?php echo e($categoryText[$complaint['category']] ?? $complaint['category']); ?>

                        </div>
                        <div class="meta-item">
                            <div class="priority-dot <?php echo e($complaint['priority']); ?>"></div>
                            <?php
                                $priorityText = [
                                    'low' => 'Rendah',
                                    'medium' => 'Sedang',
                                    'high' => 'Tinggi',
                                ];
                            ?>
                            <?php echo e($priorityText[$complaint['priority']] ?? $complaint['priority']); ?>

                        </div>
                        <div class="meta-item">
                            <span>📅</span>
                            <?php echo e(\Carbon\Carbon::parse($complaint['createdAt'])->translatedFormat('d M Y')); ?>

                        </div>
                    </div>
                    <div class="complaint-description">
                        <?php echo e(Str::limit($complaint['description'], 100)); ?>

                    </div>
                </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="empty-state">
                    <div class="empty-icon">📋</div>
                    <div class="empty-text">Belum Ada Keluhan</div>
                    <div class="empty-subtext">Buat keluhan pertama Anda untuk melaporkan masalah teknis</div>
                    <a href="<?php echo e(route('complaints.form')); ?>" class="empty-btn">Buat Keluhan</a>
                </div>
            <?php endif; ?>
        </div>

        
        <?php if(isset($pagination) && $pagination->total() > 0): ?>
            <div class="pagination">
                <?php if($pagination->onFirstPage()): ?>
                    <span class="page-link disabled">&laquo;</span>
                <?php else: ?>
                    <a href="<?php echo e($pagination->previousPageUrl()); ?>" class="page-link">&laquo;</a>
                <?php endif; ?>

                <?php $__currentLoopData = range(1, $pagination->lastPage()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($page == $pagination->currentPage()): ?>
                        <span class="page-link active"><?php echo e($page); ?></span>
                    <?php else: ?>
                        <a href="<?php echo e($pagination->url($page)); ?>" class="page-link"><?php echo e($page); ?></a>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <?php if($pagination->hasMorePages()): ?>
                    <a href="<?php echo e($pagination->nextPageUrl()); ?>" class="page-link">&raquo;</a>
                <?php else: ?>
                    <span class="page-link disabled">&raquo;</span>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
</body>
</html><?php /**PATH /home/proa8625/public_html/absensi.prodental.my.id/resources/views/complaints/complaint-history.blade.php ENDPATH**/ ?>