<?php $__env->startSection('title', 'Kelola Pengajuan Izin/Cuti'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h2>Kelola Pengajuan Izin & Cuti</h2>
    <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn-secondary">← Kembali</a>
</div>

<!-- Filter & Search -->
<div class="card" style="margin-bottom:20px">
    <form method="GET" style="display:grid;grid-template-columns:repeat(auto-fit,minmax(200px,1fr));gap:12px">
        <div>
            <label style="font-size:13px;color:#6b7280;display:block;margin-bottom:4px">Status</label>
            <select name="status" class="form-input" style="width:100%">
                <option value="">Semua Status</option>
                <option value="pending" <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>>Pending</option>
                <option value="approved" <?php echo e(request('status') == 'approved' ? 'selected' : ''); ?>>Disetujui</option>
                <option value="rejected" <?php echo e(request('status') == 'rejected' ? 'selected' : ''); ?>>Ditolak</option>
            </select>
        </div>
        
        <div>
            <label style="font-size:13px;color:#6b7280;display:block;margin-bottom:4px">Kategori</label>
            <select name="category" class="form-input" style="width:100%">
                <option value="">Semua Kategori</option>
                <option value="cuti" <?php echo e(request('category') == 'cuti' ? 'selected' : ''); ?>>Cuti</option>
                <option value="sakit" <?php echo e(request('category') == 'sakit' ? 'selected' : ''); ?>>Sakit</option>
                <option value="izin" <?php echo e(request('category') == 'izin' ? 'selected' : ''); ?>>Izin</option>
                <option value="lainnya" <?php echo e(request('category') == 'lainnya' ? 'selected' : ''); ?>>Lainnya</option>
            </select>
        </div>
        
        <div>
            <label style="font-size:13px;color:#6b7280;display:block;margin-bottom:4px">Karyawan</label>
            <select name="user_id" class="form-input" style="width:100%">
                <option value="">Semua Karyawan</option>
                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($user->id); ?>" <?php echo e(request('user_id') == $user->id ? 'selected' : ''); ?>>
                        <?php echo e($user->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        
        <div>
            <label style="font-size:13px;color:#6b7280;display:block;margin-bottom:4px">Cari</label>
            <input type="text" name="search" class="form-input" placeholder="Cari judul..." value="<?php echo e(request('search')); ?>" style="width:100%">
        </div>
        
        <div style="display:flex;align-items:end;gap:8px">
            <button type="submit" class="btn-primary" style="flex:1">Filter</button>
            <a href="<?php echo e(route('admin.complaints.index')); ?>" class="btn-secondary">Reset</a>
        </div>
    </form>
</div>

<!-- Statistics -->
<div style="display:grid;grid-template-columns:repeat(3,1fr);gap:16px;margin-bottom:24px">
    <div class="card" style="border-left:4px solid #f59e0b">
        <h3 style="font-size:13px;color:#6b7280;margin-bottom:8px">Menunggu</h3>
        <div style="font-size:28px;font-weight:700;color:#f59e0b">
            <?php echo e($complaints->where('status', 'pending')->count()); ?>

        </div>
    </div>
    <div class="card" style="border-left:4px solid #10b981">
        <h3 style="font-size:13px;color:#6b7280;margin-bottom:8px">Disetujui</h3>
        <div style="font-size:28px;font-weight:700;color:#10b981">
            <?php echo e($complaints->where('status', 'approved')->count()); ?>

        </div>
    </div>
    <div class="card" style="border-left:4px solid #ef4444">
        <h3 style="font-size:13px;color:#6b7280;margin-bottom:8px">Ditolak</h3>
        <div style="font-size:28px;font-weight:700;color:#ef4444">
            <?php echo e($complaints->where('status', 'rejected')->count()); ?>

        </div>
    </div>
</div>

<!-- Complaints Table -->
<div class="card">
    <?php if($complaints->count() > 0): ?>
        <div style="overflow-x:auto">
            <table style="width:100%;border-collapse:collapse">
                <thead>
                    <tr style="border-bottom:2px solid #e5e7eb">
                        <th style="text-align:left;padding:12px 8px;font-size:13px;color:#6b7280">Tanggal</th>
                        <th style="text-align:left;padding:12px 8px;font-size:13px;color:#6b7280">Karyawan</th>
                        <th style="text-align:left;padding:12px 8px;font-size:13px;color:#6b7280">Kategori</th>
                        <th style="text-align:left;padding:12px 8px;font-size:13px;color:#6b7280">Judul</th>
                        <th style="text-align:left;padding:12px 8px;font-size:13px;color:#6b7280">Prioritas</th>
                        <th style="text-align:center;padding:12px 8px;font-size:13px;color:#6b7280">Status</th>
                        <th style="text-align:center;padding:12px 8px;font-size:13px;color:#6b7280">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $complaints; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $complaint): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr style="border-bottom:1px solid #f3f4f6">
                        <td style="padding:12px 8px;font-size:13px">
                            <?php echo e($complaint->created_at->format('d/m/Y H:i')); ?>

                        </td>
                        <td style="padding:12px 8px;font-size:13px">
                            <strong><?php echo e($complaint->user->name); ?></strong><br>
                            <small style="color:#6b7280"><?php echo e($complaint->user->email); ?></small>
                        </td>
                        <td style="padding:12px 8px;font-size:13px">
                            <?php
                                $categoryBadge = [
                                    'cuti' => ['bg' => '#dbeafe', 'text' => '#1e40af', 'icon' => '🏖️'],
                                    'sakit' => ['bg' => '#fee2e2', 'text' => '#991b1b', 'icon' => '🤒'],
                                    'izin' => ['bg' => '#fef3c7', 'text' => '#92400e', 'icon' => '📝'],
                                    'lainnya' => ['bg' => '#f3f4f6', 'text' => '#374151', 'icon' => '💬'],
                                ];
                                $badge = $categoryBadge[$complaint->category] ?? $categoryBadge['lainnya'];
                            ?>
                            <span style="background:<?php echo e($badge['bg']); ?>;color:<?php echo e($badge['text']); ?>;padding:4px 8px;border-radius:4px;font-size:12px;font-weight:600">
                                <?php echo e($badge['icon']); ?> <?php echo e(ucfirst($complaint->category)); ?>

                            </span>
                        </td>
                        <td style="padding:12px 8px;font-size:13px"><?php echo e(Str::limit($complaint->title, 40)); ?></td>
                        <td style="padding:12px 8px;font-size:13px">
                            <?php
                                $priorityBadge = [
                                    'low' => ['bg' => '#d1fae5', 'text' => '#065f46', 'label' => 'Rendah'],
                                    'medium' => ['bg' => '#fef3c7', 'text' => '#92400e', 'label' => 'Sedang'],
                                    'normal' => ['bg' => '#fef3c7', 'text' => '#92400e', 'label' => 'Normal'],
                                    'high' => ['bg' => '#fee2e2', 'text' => '#991b1b', 'label' => 'Tinggi'],
                                ];
                                $priority = $priorityBadge[$complaint->priority] ?? $priorityBadge['medium'];
                            ?>
                            <span style="background:<?php echo e($priority['bg']); ?>;color:<?php echo e($priority['text']); ?>;padding:4px 8px;border-radius:4px;font-size:11px;font-weight:600">
                                <?php echo e($priority['label']); ?>

                            </span>
                        </td>
                        <td style="padding:12px 8px;text-align:center">
                            <form method="POST"
                                action="<?php echo e(route('admin.complaints.updateStatusAttendance', $complaint->id)); ?>">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PATCH'); ?>

                                <select name="status"
                                        onchange="this.form.submit()"
                                        style="padding:6px 10px;
                                            border-radius:8px;
                                            font-size:12px;
                                            font-weight:600;
                                            border:1px solid #e5e7eb;
                                            background:
                                            <?php echo e($complaint->status=='pending' ? '#fef3c7' :
                                                ($complaint->status=='approved' ? '#d1fae5' : '#fee2e2')); ?>;
                                            color:
                                            <?php echo e($complaint->status=='pending' ? '#92400e' :
                                                ($complaint->status=='approved' ? '#065f46' : '#991b1b')); ?>;
                                        ">
                                    <option value="pending" <?php echo e($complaint->status=='pending'?'selected':''); ?>>
                                        ⏳ Pending
                                    </option>
                                    <option value="approved" <?php echo e($complaint->status=='approved'?'selected':''); ?>>
                                        ✅ Disetujui
                                    </option>
                                    <option value="rejected" <?php echo e($complaint->status=='rejected'?'selected':''); ?>>
                                        ❌ Ditolak
                                    </option>
                                </select>
                            </form>
                        </td>
                        <td style="padding:12px 8px;text-align:center">
                            <a href="<?php echo e(route('admin.complaints.show', $complaint->id)); ?>" class="btn-primary" style="padding:6px 12px;font-size:12px">
                                👁️ Detail
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        
        <div style="margin-top:20px">
            <?php echo e($complaints->links()); ?>

        </div>
    <?php else: ?>
        <div style="text-align:center;padding:40px;color:#6b7280">
            <div style="font-size:48px;margin-bottom:16px;opacity:0.5">📝</div>
            <div>Tidak ada pengajuan ditemukan</div>
        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\absen-dutacom\resources\views/admin/complaints/index.blade.php ENDPATH**/ ?>