<?php $__env->startSection('title', 'Kelola Pengguna'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h2>Kelola Pengguna</h2>
    <div class="actions">
        <a href="<?php echo e(route('admin.users.create')); ?>" class="btn btn-primary">+ Tambah User</a>
    </div>
</div>

<div class="card" style="margin-bottom:8px;padding:12px;background:#f0f9ff;border-left:4px solid #0ea5e9">
    <p style="margin:0;font-size:13px;color:#0c4a6e">
        💡 <strong>Info Absensi:</strong> Data menampilkan kehadiran bulan ini (<?php echo e(date('F Y')); ?>)
    </p>
</div>

<div class="card" style="margin-bottom:16px">
    <form method="get" style="display:flex;gap:8px;align-items:center">
        <input type="text" name="q" placeholder="Cari nama/email/telepon..." value="<?php echo e($search); ?>" style="flex:1;margin:0" />
        <button class="btn btn-secondary" type="submit">🔍 Cari</button>
        <?php if($search): ?>
            <a href="<?php echo e(route('admin.users.index')); ?>" class="btn btn-secondary">Clear</a>
        <?php endif; ?>
    </form>
</div>

<div style="overflow-x:auto">
<table>
    <thead>
        <tr>
            <th>ID Card</th>
            <th>Nama</th>
            <th>Email</th>
            <th>Telepon</th>
            <th>Roles</th>
            <th>Shifts</th>
            <th style="text-align:center">Hadir Bulan Ini</th>
            <th style="text-align:center">Terlambat</th>
            <th style="text-align:center">Total Jam</th>
            <th>Terdaftar</th>
            <th>Aksi</th>
        </tr>
    </thead>
    <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <tr>
            <td><span style="font-weight:600;color:#0ea5e9"><?php echo e($user->employee_id ?: '-'); ?></span></td>
            <td><strong><?php echo e($user->name); ?></strong></td>
            <td><?php echo e($user->email); ?></td>
            <td><?php echo e($user->phone ?: '-'); ?></td>
            <td><span style="font-size:12px;background:#e0e7ff;color:#4338ca;padding:2px 6px;border-radius:4px;display:inline-block"><?php echo e($user->roles->pluck('name')->join(', ') ?: '-'); ?></span></td>
            <td><span style="font-size:12px;background:#fef3c7;color:#92400e;padding:2px 6px;border-radius:4px;display:inline-block"><?php echo e($user->shifts->pluck('name')->join(', ') ?: '-'); ?></span></td>
            <td style="text-align:center">
                <span style="font-size:14px;font-weight:600;color:#059669;background:#d1fae5;padding:4px 8px;border-radius:6px;display:inline-block">
                    <?php echo e($user->total_hadir ?? 0); ?> hari
                </span>
            </td>
            <td style="text-align:center">
                <span style="font-size:14px;font-weight:600;color:#dc2626;background:#fee2e2;padding:4px 8px;border-radius:6px;display:inline-block">
                    <?php echo e($user->total_terlambat ?? 0); ?>x
                </span>
            </td>
            <td style="text-align:center">
                <span style="font-size:14px;font-weight:600;color:#2563eb;background:#dbeafe;padding:4px 8px;border-radius:6px;display:inline-block">
                    <?php echo e(number_format($user->total_jam_kerja ?? 0, 1)); ?> jam
                </span>
            </td>
            <td style="font-size:12px;color:#6b7280"><?php echo e($user->created_at->format('d/m/Y')); ?></td>
            <td style="white-space:nowrap">
                <a class="btn btn-secondary" href="<?php echo e(route('admin.users.attendance',$user)); ?>" style="padding:6px 10px;font-size:13px;background:#0ea5e9;color:white" title="Lihat Detail Absensi">📊</a>
                <a class="btn btn-secondary" href="<?php echo e(route('admin.users.edit',$user)); ?>" style="padding:6px 10px;font-size:13px">Edit</a>
                <form method="post" action="<?php echo e(route('admin.users.destroy',$user)); ?>" style="display:inline" onsubmit="return confirm('Hapus user ini?')">
                    <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger" style="padding:6px 10px;font-size:13px">Hapus</button>
                </form>
            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <tr><td colspan="13" style="text-align:center;color:#9ca3af">Tidak ada data</td></tr>
        <?php endif; ?>
    </tbody>
</table>
</div>

<div class="pagination"><?php echo e($users->withQueryString()->links()); ?></div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/proa8625/public_html/absensi.prodental.my.id/resources/views/admin/users/index.blade.php ENDPATH**/ ?>